import socket;
import string;

# converts string properties to lists where expected.
machine_listen_addresses=string.split(machine_listen_addresses, ',');
managed_server_listen_port_start=int(admin_server_listen_port) + 1;
nms_machines = int(number_of_managed_servers_per_machine);

data_source_names=string.split(data_source_names, ',');
data_source_jndi_names=string.split(data_source_jndi_names, ',');
data_source_users=string.split(data_source_users, ',');
data_source_passwords=string.split(data_source_passwords, ',');
data_source_url=string.split(data_source_url, ',');
data_source_driver=string.split(data_source_driver, ',');
data_source_test=string.split(data_source_test, ',');
data_source_init_sql=string.split(data_source_init_sql, ',');

jmsResources = {}

# phrmgr queue information
jmsResources['phrmgr'] = {}
try: 
    jmsResources['phrmgr']['jms_system_resource_name']=phrmgr_jms_system_resource_name
    jmsResources['phrmgr']['sub_deployment_name']=phrmgr_sub_deployment_name
    jmsResources['phrmgr']['connection_factory_names']=string.split(phrmgr_connection_factory_names, ',');
    jmsResources['phrmgr']['connection_factory_jndi_names']=string.split(phrmgr_connection_factory_jndi_names, ',');
    jmsResources['phrmgr']['distributed_queue_names']=string.split(phrmgr_distributed_queue_names, ',');
    jmsResources['phrmgr']['distributed_queue_jndi_names']=string.split(phrmgr_distributed_queue_jndi_names, ',');
    jmsResources['phrmgr']['distributed_error_queue_names']=string.split(phrmgr_distributed_error_queue_names, ',');
    jmsResources['phrmgr']['distributed_error_queue_jndi_names']=string.split(phrmgr_distributed_error_queue_jndi_names, ',');
except:
    pass
    
# usermgmt queue information
jmsResources['usermgmt'] = {}
try:
    jmsResources['usermgmt']['jms_system_resource_name']=usermgmt_jms_system_resource_name
    jmsResources['usermgmt']['sub_deployment_name']=usermgmt_sub_deployment_name
    jmsResources['usermgmt']['connection_factory_names']=string.split(usermgmt_connection_factory_names, ',');
    jmsResources['usermgmt']['connection_factory_jndi_names']=string.split(usermgmt_connection_factory_jndi_names, ',');
    jmsResources['usermgmt']['distributed_queue_names']=string.split(usermgmt_distributed_queue_names, ',');
    jmsResources['usermgmt']['distributed_queue_jndi_names']=string.split(usermgmt_distributed_queue_jndi_names, ',');
    jmsResources['usermgmt']['distributed_error_queue_names']=string.split(usermgmt_distributed_error_queue_names, ',');
    jmsResources['usermgmt']['distributed_error_queue_jndi_names']=string.split(usermgmt_distributed_error_queue_jndi_names, ',');
except:
    pass
    
# bbmi queue information
try:
    jmsResources['bbmi'] = {}
    jmsResources['bbmi']['jms_system_resource_name']=bbmi_jms_system_resource_name
    jmsResources['bbmi']['sub_deployment_name']=bbmi_sub_deployment_name
    jmsResources['bbmi']['connection_factory_names']=string.split(bbmi_connection_factory_names, ',');
    jmsResources['bbmi']['connection_factory_jndi_names']=string.split(bbmi_connection_factory_jndi_names, ',');
    jmsResources['bbmi']['distributed_queue_names']=string.split(bbmi_distributed_queue_names, ',');
    jmsResources['bbmi']['distributed_queue_jndi_names']=string.split(bbmi_distributed_queue_jndi_names, ',');
    jmsResources['bbmi']['distributed_error_queue_names']=string.split(bbmi_distributed_error_queue_names, ',');
    jmsResources['bbmi']['distributed_error_queue_jndi_names']=string.split(bbmi_distributed_error_queue_jndi_names, ',');
except:
    pass
    
# batch queue information
jmsResources['batch'] = {}
try:
    jmsResources['batch']['jms_system_resource_name']=batch_jms_system_resource_name
    jmsResources['batch']['sub_deployment_name']=batch_sub_deployment_name
    jmsResources['batch']['connection_factory_names']=string.split(batch_connection_factory_names, ',');
    jmsResources['batch']['connection_factory_jndi_names']=string.split(batch_connection_factory_jndi_names, ',');
    jmsResources['batch']['distributed_queue_names']=string.split(batch_distributed_queue_names, ',');
    jmsResources['batch']['distributed_queue_jndi_names']=string.split(batch_distributed_queue_jndi_names, ',');
    jmsResources['batch']['distributed_error_queue_names']=string.split(batch_distributed_error_queue_names, ',');
    jmsResources['batch']['distributed_error_queue_jndi_names']=string.split(batch_distributed_error_queue_jndi_names, ',');
except:
    pass    

print 'CREATE PATHS';
domain_name=os.getenv('DOMAIN_NAME');
java_home=os.getenv('JAVA_HOME');
middleware_home=os.getenv('MIDDLEWARE_HOME');
weblogic_home=os.getenv('WEBLOGIC_HOME');
fusion_middleware_home=os.getenv('FUSION_MIDDLEWARE_HOME');
configuration_home = os.getenv('CONFIGURATION_HOME');

print 'INFO';
print 'Num Managed Servers per Machine: ' + number_of_managed_servers_per_machine;
 
domain_home=configuration_home + '/domains/' + domain_name;
domain_application_home=configuration_home + '/applications/' + domain_name;
node_manager_home=domain_home + '/nodemanager';
 
def connect_to_admin_server():
    print 'CONNECT TO ADMIN SERVER';
    admin_server_listen_address = socket.gethostname();
    print 'Admin Server URL : t3://' + admin_server_listen_address + ':' + admin_server_listen_port;
    admin_server_url = 't3://' + admin_server_listen_address + ':' + admin_server_listen_port;
    print 'Connecting to Admin Server';
    connect(admin_username, admin_password, admin_server_url);
    print 'CONNECTED!! to Admin Server';
    
def setJtaTransactionTimeout():
	print 'SETTING JTA TRANSACTIION TIMEOUT VALUE TO: ' + jta_transaction_timeout
	cd('/JTA/' + domain_name);
	set('TimeoutSeconds', jta_transaction_timeout);
 
def create_cluster():
    print 'CREATE CLUSTER';
    cluster = cmo.createCluster(cluster_name);
    cluster.setClusterMessagingMode('unicast');
    return cluster;
 
def create_dynamic_cluster():
    print 'CREATE DYNAMIC CLUSTER';
     
    cluster = cmo.createCluster(cluster_name);
    cluster.setClusterMessagingMode('unicast');
     
    cmo.createServerTemplate('server_template');
    server_template = cmo.lookupServerTemplate('server_template');
    server_template.setListenPort(managed_server_listen_port_start);
    server_template.setCluster(cluster);
    overload_protection = server_template.getOverloadProtection();
    overload_protection.setFailureAction('force-shutdown');
    overload_protection.setPanicAction('system-exit');
    overload_protection.createServerFailureTrigger();
    overload_protection.getServerFailureTrigger().setMaxStuckThreadTime(600);
    overload_protection.getServerFailureTrigger().setStuckThreadCount(0);
    server_log = server_template.getLog();
    #server_log.setFileName(domain_home + '/servers/' + managed_server_server_name + '/logs/' + managed_server_server_name + '_%yyyy%_%MM%_%dd%_%hh%_%mm%.log');
    server_log.setRotationType('byTime');
    server_log.setFileTimeSpan(24);
    server_log.setRotationTime('00:00');
    server_log.setNumberOfFilesLimited(java.lang.Boolean('true'));
    server_log.setFileCount(10);
    #server_log.setRedirectStderrToServerLogEnabled(java.lang.Boolean('true'));
    #server_log.setRedirectStdoutToServerLogEnabled(java.lang.Boolean('true'));
    server_log.setLogFileSeverity('Warning');
    server_log.setStdoutSeverity('Warning');
    server_log.setDomainLogBroadcastSeverity('Warning');
    server_log.setMemoryBufferSeverity('Warning');
    web_server_log = server_template.getWebServer().getWebServerLog();
    web_server_log.setLoggingEnabled(java.lang.Boolean('false'));
    web_server_log.setRotationType('byTime');
    web_server_log.setFileTimeSpan(24);
    web_server_log.setRotationTime('00:00');
    web_server_log.setNumberOfFilesLimited(java.lang.Boolean('true'));
    web_server_log.setFileCount(10);
    cluster.getDynamicServers().setServerTemplate(server_template);
    cluster.getDynamicServers().setMaximumDynamicServerCount(2);
    cluster.getDynamicServers().setMachineNameMatchExpression('machine*');
    cluster.getDynamicServers().setServerNamePrefix('server_');
    cluster.getDynamicServers().setCalculatedListenPorts(java.lang.Boolean('true'));
    cluster.getDynamicServers().setCalculatedMachineNames(java.lang.Boolean('true'));
    cluster.getDynamicServers().setCalculatedListenPorts(java.lang.Boolean('true'));
     
    return cluster;
 
def create_machines():
    print 'CREATE MACHINES';
    for i in range(len(machine_listen_addresses)):
        machine = cmo.createUnixMachine('machine_' + machine_listen_addresses[i]);
        machine.setPostBindUIDEnabled(java.lang.Boolean('true'));
        machine.setPostBindUID(machine_user_id);
        machine.setPostBindGIDEnabled(java.lang.Boolean('true'));
        machine.setPostBindGID(machine_group_id);
        machine.getNodeManager().setListenAddress(machine_listen_addresses[i]);
        machine.getNodeManager().setNMType(node_manager_mode);
 
def create_machines_and_servers(cluster):
    print 'CREATE MACHINES AND SERVERS';
    for i in range(len(machine_listen_addresses)):
        print 'i = ' + repr(i)
        machine = cmo.createUnixMachine(machine_listen_addresses[i]);
        machine.setPostBindUIDEnabled(java.lang.Boolean('true'));
        machine.setPostBindUID(machine_user_id);
        machine.setPostBindGIDEnabled(java.lang.Boolean('true'));
        machine.setPostBindGID(machine_group_id);
        machine.getNodeManager().setListenAddress(machine_listen_addresses[i]);
        machine.getNodeManager().setNMType(node_manager_mode);
        machine.getNodeManager().setListenPort(int(node_manager_listen_port));
        for j in range(nms_machines):
            cd('/Servers/');
            print 'j = ' + repr(j);
            managed_server_listen_port = managed_server_listen_port_start + j;
            managed_server_debug_port = managed_server_listen_port + 2000;
            
            #managed_server_server_name = 'server_' + machine_listen_addresses[i] + '_' + repr(managed_server_listen_port);
            
            managed_server_server_name = domain_name + '.ms' + repr(i) + chr(97 + j);
            server = cmo.createServer(managed_server_server_name);
            server.setListenPort(managed_server_listen_port);
            server.setListenAddress(machine_listen_addresses[i]);
            server.setCluster(cluster);
            server.setMachine(machine);
            
            cd('/Servers/' + managed_server_server_name + '/ServerStart/' + managed_server_server_name)
            set('Arguments', managed_server_arguments.replace("DEBUG_PORT", repr(managed_server_debug_port), 1));
            
            # SSL & Keystore Configuration
            cd('/Servers/' + managed_server_server_name);
            
            set('KeyStores', 'CustomIdentityAndCustomTrust');
            
            set('CustomIdentityKeyStoreFileName', '/u01/app/keystore/MHV.jks');
            set('CustomIdentityKeyStoreType', 'JKS');
            set('CustomIdentityKeyStorePassPhrase', keystore_password);
            
            set('CustomTrustKeyStoreFileName', '/u01/app/keystore/MHV.jks');
            set('CustomTrustKeyStoreType', 'JKS');
            set('CustomTrustKeyStorePassPhrase', keystore_password);
            
            cd('/Servers/' + managed_server_server_name + '/SSL/' + managed_server_server_name);
            set('IdentityAndTrustLocations', 'KeyStores');
            set('ServerPrivateKeyAlias', 'AI');
            set('ServerPrivateKeyPassPhrase', keystore_password);
            set('UseServerCerts', 'true');
            
            # TBD : May want to delete.
            #set('OutboundPrivateKeyAlias', 'AI');
            #set('OutboundPrivateKeyPassPhrase', keystore_password);
       
            
 
def create_messaging_resources(targets, jmsResource):
	if jmsResources[jmsResource] != {} :
	    print 'CREATE JMS SYSTEM MODULE ' + jmsResource;
	    cd('/');
	    module = cmo.createJMSSystemResource(jmsResources[jmsResource]['jms_system_resource_name']);
	    #module_targets = module.getTargets();
	    #module_targets.append(targets);
	    #module.setTargets(module_targets);
	    cd('/JMSSystemResources/' + jmsResources[jmsResource]['jms_system_resource_name']);
	    set('Targets', jarray.array([ObjectName('com.bea:Name=' + cluster_name + ',Type=Cluster')], ObjectName));
	    module.createSubDeployment(jmsResources[jmsResource]['sub_deployment_name']);
	    
	    resource = module.getJMSResource();
	    print 'CREATE CONNECTION FACTORY';
	    for i in range(len(jmsResources[jmsResource]['connection_factory_names'])):
	        resource.createConnectionFactory(jmsResources[jmsResource]['connection_factory_names'][i]);
	        connection_factory = resource.lookupConnectionFactory(jmsResources[jmsResource]['connection_factory_names'][i]);
	        connection_factory.setJNDIName(jmsResources[jmsResource]['connection_factory_jndi_names'][i]);
	        connection_factory.setDefaultTargetingEnabled(true);
	        connection_factory.getTransactionParams().setTransactionTimeout(0);
	        connection_factory.getTransactionParams().setXAConnectionFactoryEnabled(true);
	        connection_factory.getLoadBalancingParams().setLoadBalancingEnabled(true);
	        connection_factory.getLoadBalancingParams().setServerAffinityEnabled(false);
	
		distributed_error_queues = [];
	
	    print 'CREATE UNIFORM DISTRIBUTED ERROR QUEUE';
	    for i in range(len(jmsResources[jmsResource]['distributed_error_queue_names'])):
	        errorQueue = resource.lookupUniformDistributedQueue(jmsResources[jmsResource]['distributed_error_queue_names'][i]);
	        
	        if errorQueue is None : 
	            errorQueue = resource.createUniformDistributedQueue(jmsResources[jmsResource]['distributed_error_queue_names'][i]);
	            errorQueue.setJNDIName(jmsResources[jmsResource]['distributed_error_queue_jndi_names'][i]);
	            errorQueue.setLoadBalancingPolicy('Round-Robin');
	            errorQueue.setSubDeploymentName(jmsResources[jmsResource]['sub_deployment_name']);
	
	        distributed_error_queues.insert(i, errorQueue);
	
	    print 'DIST ERR Q LEN ' +  str(len(distributed_error_queues));
	     
	    print 'CREATE UNIFORM DISTRIBUTED QUEUE';
	    for i in range(len(jmsResources[jmsResource]['distributed_queue_names'])):
	        resource.createUniformDistributedQueue(jmsResources[jmsResource]['distributed_queue_names'][i]);
	        distributed_queue = resource.lookupUniformDistributedQueue(jmsResources[jmsResource]['distributed_queue_names'][i]);
	        distributed_queue.setJNDIName(jmsResources[jmsResource]['distributed_queue_jndi_names'][i]);
	        distributed_queue.setLoadBalancingPolicy('Round-Robin');
	        distributed_queue.setSubDeploymentName(jmsResources[jmsResource]['sub_deployment_name']);
	        distributed_queue.setForwardDelay(30);
	         
	        distributed_queue.getDeliveryFailureParams().setRedeliveryLimit(3);
	        distributed_queue.getDeliveryFailureParams().setExpirationPolicy('Redirect');
	        distributed_queue.getDeliveryFailureParams().setErrorDestination(distributed_error_queues[i]);
	        distributed_queue.getDeliveryParamsOverrides().setRedeliveryDelay(2000);
	     
	    print 'CREATE FILE STORES AND JMS SERVERS';
	     
	    sub_deployment_targets = [];
	    for i in range(len(machine_listen_addresses)):
	        for j in range(nms_machines):
	            print 'Creating Persistent File Store : ' + jmsResource + '_filestore_ms' + repr(i) + chr(97 + j)
	            cd('/');
	            file_store = cmo.createFileStore(jmsResource + '_filestore_ms' + repr(i) + chr(97+j));
	            file_store.setDirectory(domain_home);
	            cd('/FileStores/' + jmsResource + '_filestore_ms' + repr(i) + chr(97 + j))
	            set('Targets', jarray.array([ObjectName('com.bea:Name=' + domain_name + '.ms' + repr(i) + chr(97 + j) + ',Type=Server')], ObjectName));
	            # file_store.setTargets(jarray.array([ObjectName('com.bea:Name=' + domain_name + '.ms' + repr(i) + chr(97 + j) + ',Type=Server')], ObjectName));
	
	            print 'Creating jms server : ' + domain_name + '.' + jmsResource + '.jms' + repr(i) + chr(97 + j)
	            cd('/');
	            jms_server = cmo.createJMSServer(domain_name + '.' + jmsResource + '.jms' + repr(i) + chr(97 + j));
	            jms_server.setPersistentStore(file_store);
	
	            print 'Setting JMS Server Targets'
	            cd('/Deployments/' + domain_name + '.' + jmsResource + '.jms' + repr(i) + chr(97 + j));
	            set('Targets', jarray.array([ObjectName('com.bea:Name=' + domain_name + '.ms' + repr(i) + chr(97 + j) +',Type=Server')], ObjectName));
	            #jms_server.setTargets(jarray.array([ObjectName('com.bea:Name=' + domain_name + '.ms' + repr(i) + chr(97 + j) +',Type=Server')], ObjectName));
	            
	            # set the target of the subdeployment to the jms server for the machine
	            cd('/JMSSystemResources/' + jmsResources[jmsResource]['jms_system_resource_name'] + '/SubDeployments/' + jmsResources[jmsResource]['sub_deployment_name'])
	            set('Targets', jarray.array([ObjectName('com.bea:Name=' + domain_name + '.' + jmsResource + '.jms' + repr(i) + chr(97 + j) + ',Type=JMSServer')], ObjectName));
	
    	cd('/');
	
     
def create_data_source(targets):
    for i in range(len(data_source_names)):
        print 'CREATE DATA SOURCE';
        data_source = cmo.createJDBCSystemResource(data_source_names[i]);
        data_source_targets = data_source.getTargets();
        data_source_targets.append(targets);
        data_source.setTargets(data_source_targets);
        jdbc_resource = data_source.getJDBCResource();
        jdbc_resource.setName(data_source_names[i]);
         
        data_source_params = jdbc_resource.getJDBCDataSourceParams();
        names = [data_source_jndi_names[i]];
        data_source_params.setJNDINames(names);
        #data_source_params.setGlobalTransactionsProtocol('EmulateTwoPhaseCommit');
        #data_source_params.setGlobalTransactionsProtocol('LoggingLastResource');
        driver_params = jdbc_resource.getJDBCDriverParams();
        driver_params.setUrl(data_source_url[i]);
        driver_params.setDriverName(data_source_driver[i]);
        driver_params.setPassword(data_source_passwords[i]);
        driver_properties = driver_params.getProperties();
        driver_properties.createProperty('user');
        user_property = driver_properties.lookupProperty('user');
        user_property.setValue(data_source_users[i]);
         
        connection_pool_params = jdbc_resource.getJDBCConnectionPoolParams();
        connection_pool_params.setTestTableName(data_source_test[i]);
        connection_pool_params.setConnectionCreationRetryFrequencySeconds(30);
        connection_pool_params.setStatementCacheSize(0);
        connection_pool_params.setInitSql(data_source_init_sql[i])
     
def create_gridlink_data_source(targets):
    for i in range(len(data_source_names)):
        print 'CREATE GRIDLINK DATA SOURCE';
        data_source = cmo.createJDBCSystemResource(data_source_names[i]);
        data_source_targets = data_source.getTargets();
        data_source_targets.append(targets);
        data_source.setTargets(data_source_targets);
         
        jdbc_resource = data_source.getJDBCResource();
        jdbc_resource.setName(data_source_names[i]);
         
        data_source_params = jdbc_resource.getJDBCDataSourceParams();
        names = [data_source_jndi_names[i]];
        data_source_params.setJNDINames(names);
        data_source_params.setGlobalTransactionsProtocol('EmulateTwoPhaseCommit');
        #data_source_params.setGlobalTransactionsProtocol('LoggingLastResource');
         
        driver_params = jdbc_resource.getJDBCDriverParams();
        driver_params.setUrl(data_source_url);
        driver_params.setDriverName(data_source_driver);
        driver_params.setPassword(data_source_passwords[i]);
        driver_properties = driver_params.getProperties();
        driver_properties.createProperty('user');
        user_property = driver_properties.lookupProperty('user');
        user_property.setValue(data_source_users[i]);
         
        connection_pool_params = jdbc_resource.getJDBCConnectionPoolParams();
        connection_pool_params.setTestTableName(data_source_test);
        connection_pool_params.setConnectionCreationRetryFrequencySeconds(30);
        connection_pool_params.setStatementCacheSize(0);
         
        oracle_params = jdbc_resource.getJDBCOracleParams();
        oracle_params.setFanEnabled(java.lang.Boolean('true'));
        oracle_params.setOnsNodeList(data_source_ons_node_list);
        oracle_params.setOnsWalletFile('');
        oracle_params.unSet('OnsWalletPassword');
        oracle_params.unSet('OnsWalletPasswordEncrypted');
        oracle_params.setActiveGridlink(java.lang.Boolean('true'));

def create_users_and_map_roles():
    print 'START SERVER CONFIG';
    serverConfig();
    print 'CREATE USERS AND MAP ROLES';
    security_realm = cmo.getSecurityConfiguration().getDefaultRealm();
    authentication_provider = security_realm.lookupAuthenticationProvider('DefaultAuthenticator');
    authentication_provider.createUser('employee', 'welcome1', 'an employee');
    authentication_provider.createUser('manager', 'welcome1', 'a manager');
    authentication_provider.createGroup('employees', 'employee group');
    authentication_provider.createGroup('managers', 'manager group');
    authentication_provider.addMemberToGroup('employees', 'employee');
    authentication_provider.addMemberToGroup('managers', 'manager');
    #role_mapper = security_realm.lookupRoleMapper('XACMLRoleMapper');
    #role_expression = role_mapper.getRoleExpression(None, 'Admin');
    #role_mapper.setRoleExpression(None, 'Admin', role_expression + '|Grp(employees)');
    #role_expression = role_mapper.getRoleExpression(None, 'Deployer');
    #role_mapper.setRoleExpression(None, 'Deployer', role_expression + '|Grp(managers)');
 
def start_edit_mode():
    print 'START EDIT MODE';
    edit();
    startEdit();
 
def save_and_active_changes():
    print 'SAVE AND ACTIVATE CHANGES';
    save();
    activate(block='true');

def create_jms_servers():
    print 'CREATE JMS SERVERS';
    sub_deployment_targets = [];
    for i in range(len(machine_listen_addresses)):
        for j in range(nms_machines):
            print 'Creating Persistent File Store : ' + 'filestore_ms' + repr(i) + chr(97 + j)
            cd('/');
            file_store = cmo.createFileStore('filestore_ms' + repr(i) + chr(97+j));
            file_store.setDirectory(domain_home);
            cd('/FileStores/filestore_ms' + repr(i) + chr(97 + j))
            set('Targets', jarray.array([ObjectName('com.bea:Name=' + domain_name + '.ms' + repr(i) + chr(97 + j) + ',Type=Server')], ObjectName));
            # file_store.setTargets(jarray.array([ObjectName('com.bea:Name=' + domain_name + '.ms' + repr(i) + chr(97 + j) + ',Type=Server')], ObjectName));

            print 'Creating jms server : ' + domain_name + '.jms' + repr(i) + chr(97 + j)
            cd('/');
            jms_server = cmo.createJMSServer(domain_name + '.jms' + repr(i) + chr(97 + j));
            jms_server.setPersistentStore(file_store);

            print 'Setting JMS Server Targets'
            cd('/Deployments/' + domain_name + '.jms' + repr(i) + chr(97 + j));
            set('Targets', jarray.array([ObjectName('com.bea:Name=' + domain_name + '.ms' + repr(i) + chr(97 + j) +',Type=Server')], ObjectName));
            #jms_server.setTargets(jarray.array([ObjectName('com.bea:Name=' + domain_name + '.ms' + repr(i) + chr(97 + j) +',Type=Server')], ObjectName));

            print 'sub_deploment_targets'
            sub_deployment_targets.append(ObjectName(repr(jms_server.getObjectName())));

    cd('/JMSSystemResources/'+ jms_system_resource_name +'/SubDeployments/' + sub_deployment_name);
    set('Targets', jarray.array(sub_deployment_targets, ObjectName));
    cd('/'); 


connect_to_admin_server();
 
start_edit_mode();
 
# #cluster = create_dynamic_cluster();
 
# #create_machines();
 
cluster = create_cluster();
 
create_machines_and_servers(cluster);
 
save_and_active_changes();
 
start_edit_mode();
 
create_messaging_resources(cluster, 'phrmgr');

create_messaging_resources(cluster, 'usermgmt');
 
create_messaging_resources(cluster, 'bbmi');

create_messaging_resources(cluster, 'batch');

create_data_source(cluster);

setJtaTransactionTimeout();
 
# #create_gridlink_data_source(cluster);
# create_jms_servers(); 
save_and_active_changes();
 
# #create_users_and_map_roles();
 
print 'DISCONNECT FROM THE ADMIN SERVER';
disconnect();   



